ORCA/M Asm65816 2.1.0

0001 0830                       title 'Tool Locator--Tool Loading'
0002 0830              ****************************************************************
0003 0830              *                                                              *
0004 0830              *                     Tool Loading                             *
0005 0830              *                                                              *
0006 0830              ****************************************************************
0007 0830
0008 0830
0009 0830              ****************************************************************
0010 0830              *                                                              *
0011 0830              *                  Copyright (C) 1985-1989                     *
0012 0830              *                  All Rights Reserved                         *
0013 0830              *                  Apple Computer, Inc.                        *
0014 0830              *                                                              *
0015 0830              ****************************************************************
0016 0830
0017 0830              **********************************************************************
0018 0830              *
0019 0830              * Change History
0020 0830              *
0021 0830              * 15 Mar 89        Steven Glass
0022 0830              *
0023 0830              * UnloadThisTool no longer can cause a system death.  It used to
0024 0830              * die on unexpected loader errors.  There are now just ignored.
0025 0830              *
0026 0830              * 07 Apr 89        Steven Glass
0027 0830              *
0028 0830              * Added range check to UnloadThisTool
0029 0830              *
0030 0830              * 4/6/90           Mensch
0031 0830              * Fixed range check in UnloadThisTool it will now correctly test the
0032 0830              * current TPT.
0033 0830              *
0034 0830              **********************************************************************
0035 0830
0036 0830                       blanks off 
0037 0830                       string asis 
0038 0830
0039 0830                       print push 
0040 0830                       print off 
0041 0830                       include 'all.macros' 
0042 0830                       include '::sys.equs.asm' 
0043 0830                       INCLUDE 'e16.memory' 
0044 0830
0045 0830                       include 'tl.equates.asm' 
0046 0830                       print pop 
0047 0830
0048 0830
0049 0830
0050 0830
0051 0830                       title ' Imported Addresses' 
0052 0830              ;-----------------------------------------------
0053 0830              ;
0054 0830              ;   Imported addresses
0055 0830              ;
0056 0830              ;-----------------------------------------------
0057 0830
0058 0830                       IMPORT BusyErr4 
0059 0830
0060 0830                       eject 
0061 0830              ****************************************************************
0062 0830              *
0063 0830              LoadTools PROC EXPORT 
0064 0830              *
0065 0830              *         Pointer to ToolTable
0066 0830              *
0067 0830              * where ToolTable looks
0068 0830              *
0069 0830              *              dc i'NumTools'
0070 0830              *              dc i'ToolNum1,MinVersion1'
0071 0830              *              dc i'ToolNum2,MinVersion2'
0072 0830              *              .
0073 0830              *              .
0074 0830              *              .
0075 0830              *
0076 0830              *
0077 0830              * The tools are kept in the subdirectory TOOLS in the system
0078 0830              * subdirectory with the following naming convention:
0079 0830              *
0080 0830              *          Tool015   for tool set 15
0081 0830              *          Tool023   for tool set 23
0082 0830              *
0083 0830              * etc.
0084 0830              *
0085 0830              * Tools 1 through 13 are in ROM.  The only parts of them that
0086 0830              * will be in RAM are not loaded in this way but are part of the
0087 0830              * patch mechanism.
0088 0830              *
0089 0830              *
0090 0830              *
0091 0830              *
0092 0830              * Inputs:
0093 0830              *	ToolTablePtr : Long
0094 0830              *
0095 0830              * Outputs:
0096 0830              *	none
0097 0830              *
0098 0830              * External Refs:
0099 0830                       import GetSpecialFlag 
0100 0830                       import LoadThisTool 
0101 0830                       import ReportIfMissing         ;16-Dec-91 DAL
0102 0830              *
0103 0830              * Entry Points:
0104 0830              *	none
0105 0830              *
0106 0830                       longa on                       ; mode
0107 0830                       longi on
0108 0830              *
0109 0830              * Change History
0110 0830              *
0111 0830              * 05 Oct 87    Steven Glass
0112 0830              *
0113 0830              *    Changes were made to this call to accomdate new calling
0114 0830              *    structure for LoadThisTool.  Additionally, changes were
0115 0830              *    made to get rid of the special memory global variable.
0116 0830              *
0117 0830              *    Finally, this call was adjusted to use the new exit
0118 0830              *    routines.
0119 0830              *
0120 0830              ****************************************************************
0121 0830
0122 0830
0123 0830                       DefineStack 
0124 0830              Counter  word 
0125 0830              SpecialFlag word 
0126 0830              CurPtr   long 
0127 0830              OrigD    word 
0128 0830              RTL1     block 3 
0129 0830              RTL2     block 3 
0130 0830              ToolTablePtr long 
0131 0830
0132 0830 0B                    phd                            ; save direct
0133 0831 A9 00 00              lda   #0                       ; put eight extra bytes on stack
0134 0834 48                    pha                            ; (all zeros)
0135 0835 48                    pha   
0136 0836 48                    pha   
0137 0837 48                    pha   
0138 0838 3B                    tsc                            ; get stack
0139 0839 5B                    tcd                            ; set stack to zp
0140 083A
0141 083A 22 64 00 E1           jsl   IncBusyFlg
0142 083E
0143 083E 8B                    phb                            ; save and set data bank
0144 083F 4B                    phk   
0145 0840 AB                    plb   
0146 0841
0147 0841 20 25 09              jsr   GetSpecialFlag           ; init the special flag.
0148 0844 85 03                 sta   SpecialFlag
0149 0846
0150 0846 A5 11                 lda   ToolTablePtr             ; init CurPtr
0151 0848 18                    clc   
0152 0849 69 02 00              adc   #2
0153 084C 85 05                 sta   CurPtr
0154 084E A5 13                 lda   ToolTablePtr+2
0155 0850 69 00 00              adc   #0
0156 0853 85 07                 sta   CurPtr+2
0157 0855
0158 0855 A5 01        Loop     lda   Counter                  ; test counter to see if we are
0159 0857 C7 11                 cmp   [ToolTablePtr]           ; done.
0160 0859 B0 27                 bcs   AllDone
0161 085B
0162 085B
0163 085B 48                    pha                            ; space for result
0164 085C A7 05                 lda   [CurPtr]                 ; Push Tool Number
0165 085E 48                    pha   
0166 085F A0 02 00              ldy   #2                       ; Push min version from table
0167 0862 B7 05                 lda   [CurPtr],y               ; 
0168 0864 48                    pha   
0169 0865 D4 03                 pei   SpecialFlag
0170 0867 20 4D 09              jsr   LoadThisTool             ; get it loaded
0171 086A FA                    plx   
0172 086B 86 03                 stx   SpecialFlag
0173 086D B0 16                 bcs   ErrorOut                 ; if error occured, quit.
0174 086F
0175 086F A5 05                 lda   CurPtr                   ; bump pointer into table
0176 0871 18                    clc   
0177 0872 69 04 00              adc   #4
0178 0875 85 05                 sta   CurPtr
0179 0877 A5 07                 lda   CurPtr+2
0180 0879 69 00 00              adc   #0
0181 087C 85 07                 sta   CurPtr+2
0182 087E
0183 087E E6 01                 inc   Counter                  ; bump counter
0184 0880 80 D3                 bra   Loop
0185 0882
0186 0882              AllDone                                 ; 
0187 0882 A9 00 00              lda   #0                       ; signal no error and fall into
0188 0885              ;                                       ; error out routine
0189 0885
0190 0885              ErrorOut  
0191 0885 AB                    plb                            ; restore DBR
0192 0886 AA                    tax   
0193 0887
0194 0887 7A                    ply                            ; clean up the stack
0195 0888 7A                    ply   
0196 0889 7A                    ply   
0197 088A 7A                    ply   
0198 088B 5C 1C FC FE           jml   BusyErr4
0199 088F
0200 088F                       ENDP 
0201 088F
0202 088F
0203 088F                       title 'LoadOneTool' 
0204 088F              ****************************************************************
0205 088F              *
0206 088F              LoadOneTool PROC EXPORT 
0207 088F              *
0208 088F              * Assures that the specified tool is available and has a version 
0209 088F              * number equal to or greater than MinVersion.  If the tool is not
0210 088F              * loaded when the call is made it trys to load the tool from disk.
0211 088F              *
0212 088F              * If the tool is not on disk or the required version is not available
0213 088F              * errors are returned.
0214 088F              *
0215 088F              *
0216 088F              * Inputs:
0217 088F              *         ToolNumber : word
0218 088F              *         MinVersion : word
0219 088F              *
0220 088F              * Outputs:
0221 088F              *	none
0222 088F              *
0223 088F              * External Refs:
0224 088F                       import GetSpecialFlag 
0225 088F                       import LoadThisTool 
0226 088F              *
0227 088F              * Entry Points:
0228 088F              *	none
0229 088F              *
0230 088F                       longa on                       ; mode
0231 088F                       longi on
0232 088F              *
0233 088F              *
0234 088F              * Change History
0235 088F              *
0236 088F              *   05 Nov 86   SEG    The Stack equates were off by one.  The
0237 088F              *                      data bank register was not accounted for.
0238 088F              *
0239 088F              *   05 Oct 87   SEG    Uses direct page addressing instead of 
0240 088F              *                      stack.
0241 088F              *
0242 088F              *                      Uses new format of LoadThisTool call.
0243 088F              *
0244 088F              *                      Uses new exit routines.
0245 088F              *
0246 088F              *   14 Oct 87   SEG    Extra D-reg no longer left on stack.
0247 088F              *
0248 088F              ****************************************************************
0249 088F
0250 088F
0251 088F                       DefineStack 
0252 088F              OrigD    word 
0253 088F              RTL1     block 3 
0254 088F              RTL2     block 3 
0255 088F              MinVersion word 
0256 088F              ToolNumber word 
0257 088F
0258 088F 0B                    phd                            ; save direct
0259 0890 3B                    tsc                            ; get stack
0260 0891 5B                    tcd                            ; set stack to zp
0261 0892
0262 0892 22 64 00 E1           jsl   IncBusyFlg
0263 0896
0264 0896 8B                    phb   
0265 0897 4B                    phk   
0266 0898 AB                    plb   
0267 0899
0268 0899 48                    pha                            ; space for result
0269 089A D4 0B                 pei   ToolNumber
0270 089C D4 09                 pei   MinVersion
0271 089E 20 25 09              jsr   GetSpecialFlag
0272 08A1 48                    pha   
0273 08A2 20 4D 09              jsr   LoadThisTool             ; get it loaded
0274 08A5
0275 08A5 FA                    plx                            ; ignore the result
0276 08A6
0277 08A6 AB                    plb                            ; restore dbr
0278 08A7
0279 08A7 AA                    tax                            ; error code in x
0280 08A8 5C 1C FC FE           jml   BusyErr4
0281 08AC
0282 08AC                       ENDP 
0283 08AC
0284 08AC
0285 08AC                       title 'UnloadOneTool' 
0286 08AC              ****************************************************************
0287 08AC              *
0288 08AC              UnLoadOneTool PROC EXPORT 
0289 08AC              *
0290 08AC              * Unloads the specified tool in the following way:  If it was
0291 08AC              * loaded from disk it calls the Loader to put it in zombie state
0292 08AC              * and installs a dummy tool table for the specified tool.
0293 08AC              *
0294 08AC              * If the tool was not loaded from disk, this proc does nothing.
0295 08AC              *
0296 08AC              *
0297 08AC              * Inputs:
0298 08AC              *                   ToolNumber : integer
0299 08AC              *
0300 08AC              * Outputs:
0301 08AC              *                   none
0302 08AC              *
0303 08AC              * External Refs:
0304 08AC                       import SetupForUnload 
0305 08AC                       import CleanupForUnload 
0306 08AC                       import UnloadThisTool 
0307 08AC              *
0308 08AC              * Entry Points:
0309 08AC              *	none
0310 08AC              *
0311 08AC                       longa on                       ; mode
0312 08AC                       longi on
0313 08AC              *
0314 08AC              * Change History
0315 08AC              *
0316 08AC              * 05 Oct 87    Steven Glass
0317 08AC              *
0318 08AC              *    This call was adjusted to use the new exit routines.
0319 08AC              *
0320 08AC              *    No changes were need to make this run in ROM.  Many changes
0321 08AC              *    were made however to adjust this to the new tool loading
0322 08AC              *    algorithm.  
0323 08AC              *
0324 08AC              ****************************************************************
0325 08AC
0326 08AC
0327 08AC
0328 08AC              RTL1     equ 1 
0329 08AC              RTL2     equ RTL1+3 
0330 08AC              ToolNumber equ RTL2+3 
0331 08AC
0332 08AC
0333 08AC 22 64 00 E1           jsl   IncBusyFlg
0334 08B0
0335 08B0 A3 07                 lda   ToolNumber,s
0336 08B2
0337 08B2
0338 08B2                       DefineStack 
0339 08B2              OrigD    word 
0340 08B2              RealTPT  long 
0341 08B2              DefaultTPT long 
0342 08B2              Counter  word 
0343 08B2
0344 08B2 20 30 0B              jsr   SetupforUnload           ; preserves a-reg
0345 08B5
0346 08B5 85 0B                 sta   Counter
0347 08B7
0348 08B7 20 D4 0A              jsr   UnloadThisTool
0349 08BA
0350 08BA 20 55 0B              jsr   CleanupForUnload
0351 08BD
0352 08BD AA                    tax   
0353 08BE
0354 08BE A0 02 00              ldy   #2
0355 08C1 5C 80 01 E1           jml   ToBusyStrip
0356 08C5
0357 08C5                       ENDP 
0358 08C5
0359 08C5                       title 'SetDefaultTPT' 
0360 08C5              ****************************************************************
0361 08C5              *
0362 08C5              SetDefaultTPT PROC EXPORT 
0363 08C5              *
0364 08C5              * Makes the current TPT the default TPT by making a copy of it.
0365 08C5              * To do this we first size the default TPT, then copy the 
0366 08C5              * real TPT to the default one.
0367 08C5              *
0368 08C5              *
0369 08C5              * Inputs:
0370 08C5              *	none
0371 08C5              *
0372 08C5              * Outputs:
0373 08C5              *	none
0374 08C5              *
0375 08C5              * External Refs:
0376 08C5                       import SetupForUnload 
0377 08C5                       import CleanupForUnload 
0378 08C5                       import TLGetMem 
0379 08C5              *
0380 08C5              * Entry Points:
0381 08C5              *	none
0382 08C5              *
0383 08C5                       longa on                       ; mode
0384 08C5                       longi on
0385 08C5              *
0386 08C5              * Change History
0387 08C5              *
0388 08C5              * 05 Oct 87    Steven Glass
0389 08C5              *
0390 08C5              *    This call was added to support new tool loading algorithm.
0391 08C5              *
0392 08C5              ****************************************************************
0393 08C5
0394 08C5                       DefineStack 
0395 08C5              OrigD    word 
0396 08C5              RealTPT  long 
0397 08C5              DefaultTPT long 
0398 08C5              Counter  word 
0399 08C5
0400 08C5              ;---------------------------------------------------
0401 08C5              ;
0402 08C5              ; Set things up.  Inc busy flag and use same routine
0403 08C5              ; as used for unloading to setup stack as d-page.
0404 08C5              ;
0405 08C5
0406 08C5 22 64 00 E1           jsl   IncBusyFlg
0407 08C9
0408 08C9 20 30 0B              jsr   SetupForUnload
0409 08CC
0410 08CC              ;---------------------------------------------------
0411 08CC              ;
0412 08CC              ; First make the default table the same size as
0413 08CC              ; the real table.
0414 08CC              ;
0415 08CC
0416 08CC A5 07                 lda   DefaultTPT
0417 08CE 05 09                 ora   DefaultTPT+2
0418 08D0 F0 14                 beq   NoneToDispose
0419 08D2
0420 08D2 48                    pha                            ; start by finding the handle
0421 08D3 48                    pha                            ; to the default tpt memory
0422 08D4 D4 09                 pei   DefaultTPT+2
0423 08D6 D4 07                 pei   DefaultTPT
0424 08D8 A2 02 1A 22           _FindHandle 
0425 08DF A2 02 10 22           _DisposeHandle                 ; and disposing it
0426 08E6
0427 08E6 A7 03        NoneToDispose lda   [RealTPT]           ; Now get size of the real
0428 08E8 0A                    asl   a                        ; tpt by taking num entries
0429 08E9 0A                    asl   a                        ; times 4
0430 08EA A2 08 80              ldx   #attrNoSpec+attrLocked   ; Get handle of this size and 
0431 08ED 20 AB 07              jsr   TLGetMem                 ; these attributes
0432 08F0 85 07                 sta   DefaultTPT               ; Deref handle and put ptr
0433 08F2 86 09                 stx   DefaultTPT+2             ; in place.
0434 08F4 A7 07                 lda   [DefaultTPT]
0435 08F6 AA                    tax   
0436 08F7 A0 02 00              ldy   #2
0437 08FA B7 07                 lda   [DefaultTPT],y
0438 08FC 85 09                 sta   DefaultTPT+2
0439 08FE 8F 8A 01 E1           sta   >DefaultTPTPtr+2
0440 0902 86 07                 stx   DefaultTPT
0441 0904 8A                    txa   
0442 0905 8F 88 01 E1           sta   >DefaultTPTPtr
0443 0909
0444 0909
0445 0909              ;---------------------------------------------------
0446 0909              ;
0447 0909              ; Now copy the contentes of the real table to the
0448 0909              ; default table.
0449 0909              ;
0450 0909 A7 03                 lda   [RealTPT]
0451 090B 0A                    asl   a
0452 090C 0A                    asl   a
0453 090D A8                    tay   
0454 090E 88                    dey   
0455 090F 88                    dey   
0456 0910
0457 0910 B7 03        Loop     lda   [RealTPT],y
0458 0912 97 07                 sta   [DefaultTPT],y
0459 0914 88                    dey   
0460 0915 88                    dey   
0461 0916 10 F8                 bpl   Loop
0462 0918
0463 0918
0464 0918              ;---------------------------------------------------
0465 0918              ;
0466 0918              ; Clean everything up.
0467 0918              ;
0468 0918 20 55 0B              jsr   CleanupForUnload
0469 091B
0470 091B
0471 091B A2 00 00              ldx   #0
0472 091E A0 00 00              ldy   #0
0473 0921 5C 80 01 E1           jml   ToBusyStrip
0474 0925
0475 0925                       ENDP 
0476 0925
0477 0925
0478 0925                       title 'GetSpecialFlag' 
0479 0925              ****************************************************************
0480 0925              *
0481 0925              GetSpecialFlag PROC 
0482 0925              *
0483 0925              * Returns value of SpecialMemory flag in a-reg.
0484 0925              *
0485 0925              *
0486 0925              * Inputs:
0487 0925              *                   none
0488 0925              *
0489 0925              * Outputs:
0490 0925              *                   none
0491 0925              *
0492 0925              * External Refs:
0493 0925              *                   none
0494 0925              *
0495 0925              * Entry Points:
0496 0925              *                   none
0497 0925              *
0498 0925                       longa on                       ; mode
0499 0925                       longi on
0500 0925              *
0501 0925              * Change History
0502 0925              *
0503 0925              * 05 Oct 87    Steven Glass
0504 0925              *
0505 0925              *    This call no longer sets a global variable, but rather
0506 0925              *    returns with the value fo that variable in the a-reg.
0507 0925              *
0508 0925              *    The name of this routine was changed from SetSpecialFlag
0509 0925              *    to GetSpecialFlag.
0510 0925              *
0511 0925              ****************************************************************
0512 0925
0513 0925
0514 0925 48                    pha   
0515 0926 48                    pha   
0516 0927 A2 02 1D 22           _TotalMem 
0517 092E 68                    pla   
0518 092F 68                    pla   
0519 0930 C9 04 00              cmp   #^256*1024
0520 0933 F0 14                 beq   BaseMachine
0521 0935
0522 0935 48                    pha   
0523 0936 48                    pha   
0524 0937 A2 02 1B 22           _FreeMem 
0525 093E 68                    pla   
0526 093F 68                    pla   
0527 0940 C9 03 00              cmp   #^200*1024
0528 0943 90 04                 bcc   NotEnough
0529 0945
0530 0945 A9 00 80              lda   #$8000
0531 0948 60                    rts   
0532 0949
0533 0949              NotEnough                               ; 
0534 0949              BaseMachine                             ; 
0535 0949 A9 00 00              lda   #0
0536 094C 60                    rts   
0537 094D
0538 094D
0539 094D                       ENDP 
0540 094D
0541 094D
0542 094D                       title 'LoadThisTool' 
0543 094D              ****************************************************************
0544 094D              *
0545 094D              LoadThisTool PROC 
0546 094D              *
0547 094D              *
0548 094D              * Loads the tool, installs it, checks its version number 
0549 094D              * against the min required.
0550 094D              *
0551 094D              * How its done
0552 094D              *
0553 094D              *     Version is checked for desired tool.  If the currently installed
0554 094D              *     tool has a good enough version number, we are done.  If the version 
0555 094D              *     number is bad or the tool is not installed we try and load
0556 094D              *     the tool from disk as follows:
0557 094D              *
0558 094D              *       First try a restart in case the tool is alread in memory.  If this
0559 094D              *       works, install the tool, do the version check and quit
0560 094D              *
0561 094D              *       If the tool cannot be restarted, create the pathname 
0562 094D              *       of the the tool to load.
0563 094D              *
0564 094D              *       Use the specialFlag to decide how to load the tool (special
0565 094D              *       mem or not).  If a non special mem load fails, try again in 
0566 094D              *       special.
0567 094D              *
0568 094D              *       Install the TPT that is at the start of the load file.
0569 094D              *
0570 094D              *       Verify the version number.
0571 094D              *
0572 094D              *     Many different errors can be returned:
0573 094D              *
0574 094D              *       Any loader errors including volume not found and not enough memory.
0575 094D              *       The version error can also be returned.
0576 094D              *
0577 094D              *
0578 094D              *
0579 094D              * Inputs:
0580 094D              *     ToolNumber              : word
0581 094D              *     MinVersion              : word
0582 094D              *     SpecialFlag             : word
0583 094D              *
0584 094D              * Outputs:
0585 094D              *     NewValue of SpecialFlag  : word
0586 094D              *
0587 094D              * External Refs:
0588 094D                       import TLGetMem 
0589 094D                       import MakeIDNum 
0590 094D              *
0591 094D              * Entry Points:
0592 094D              *	none
0593 094D              *
0594 094D                       longa on                       ; mode
0595 094D                       longi on
0596 094D              *
0597 094D              * Change History
0598 094D              *
0599 094D              * 29 January 87    Steven Glass
0600 094D              *
0601 094D              *    When a prodos error occured I was comparing the error code to $0201
0602 094D              *    (memfull).  When not equal I was trying to exit with error code in
0603 094D              *    A-reg but compare cleared carry causing all sorts of grief.
0604 094D              *
0605 094D              *
0606 094D              * 05 Oct 87    Steven Glass
0607 094D              *
0608 094D              *    Adjustments were necessary to run out of ROM.
0609 094D              *    This routine now has inputs and outputs on the stack.  It
0610 094D              *    does not use inline data storage.
0611 094D              *
0612 094D              *    Version checking is now in-line rather than a subroutine
0613 094D              *    call.  This made it possible to share local variables
0614 094D              *    and since no other routine was using this code, it saved
0615 094D              *    the JSR/RTS.
0616 094D              *
0617 094D              *    MakeToolPath is now part of this routine.  It was never
0618 094D              *    called by any other routine and making it part of this
0619 094D              *    routine makes it easier to share local data.
0620 094D              *
0621 094D              *    The tool path name is now created in a handle rather than
0622 094D              *    in line.  The handle is obtained by MakeToolPath and
0623 094D              *    disposed of during clean up.
0624 094D              *
0625 094D              ****************************************************************
0626 094D
0627 094D
0628 094D                       DefineStack 
0629 094D              PathHandle long 
0630 094D              PathPtr  long 
0631 094D              OrigD    word 
0632 094D              RTSAdr   word 
0633 094D              TheSpecialFlag word 
0634 094D              TheMinVersion word 
0635 094D              TheToolNumber word 
0636 094D              ResultSpecialFlag word 
0637 094D
0638 094D
0639 094D              ;---------------------------------------------------
0640 094D              ;
0641 094D              ; Save, direct reg, get space for locals and 
0642 094D              ; turn stack into direct page.
0643 094D              ;
0644 094D
0645 094D 0B                    phd                            ; save direct
0646 094E A9 00 00              lda   #0                       ; put zeros on stack
0647 0951 48                    pha                            ; for path handle and
0648 0952 48                    pha                            ; ptr
0649 0953 48                    pha   
0650 0954 48                    pha   
0651 0955 3B                    tsc                            ; turn stack into 
0652 0956 5B                    tcd                            ; direct page
0653 0957
0654 0957              ;---------------------------------------------------
0655 0957              ;
0656 0957              ; Check to see if this is a tool we have to load.
0657 0957              ; If the version number checks out then there is
0658 0957              ; nothing else to do.  If the version does not
0659 0957              ; check out, then try to load it from the 
0660 0957              ; system disk.
0661 0957              ;
0662 0957 20 F5 09              jsr   CheckVersion
0663 095A 90 54                 bcc   FastExit
0664 095C
0665 095C C9 11 00              cmp   #17                      ; the loader is never loaded
0666 095F F0 4C                 beq   DoNotLoad                ; from disk
0667 0961
0668 0961              ;---------------------------------------------------
0669 0961              ;
0670 0961              ; Try Restart, just in case it is already in 
0671 0961              ; memory.
0672 0961              ;
0673 0961
0674 0961 A5 11                 lda   TheToolNumber
0675 0963 20 69 0B              jsr   MakeIDNum
0676 0966
0677 0966 DA                    phx                            ; space for zp segment size
0678 0967 DA                    phx                            ; space for zp segment starting address
0679 0968 DA                    phx                            ; space for starting address
0680 0969 DA                    phx   
0681 096A DA                    phx                            ; make space for returning user id
0682 096B 48                    pha                            ; push the id of the tool
0683 096C A2 11 0A 22           _RESTART 
0684 0973 90 23                 bcc   SkipInitialLoad
0685 0975
0686 0975 68                    pla                            ; clear off junk id
0687 0976 68                    pla                            ; clear off junk starting addr
0688 0977 68                    pla   
0689 0978 68                    pla                            ; clear off junk zp seg
0690 0979 68                    pla                            ; clear off junk zp size
0691 097A
0692 097A              ;---------------------------------------------------
0693 097A              ;
0694 097A              ; Restart failed, so make pathname of tool to load
0695 097A              ;
0696 097A
0697 097A 20 3A 0A              jsr   MakeToolPath             ; make tool path uses ts num in a-reg
0698 097D B0 31                 bcs   LoadError
0699 097F
0700 097F              ;---------------------------------------------------
0701 097F              ;
0702 097F              ; First look at the SpecialFlag.  If it is clear
0703 097F              ; then don't try to load outside of special memory
0704 097F              ; (we already know that it won't work).
0705 097F              ;
0706 097F A6 0D                 ldx   TheSpecialFlag
0707 0981 F0 0E                 beq   TooSmall
0708 0983 20 D5 09              jsr   DoInitialLoad            ; load into non special memory
0709 0986 90 15                 bcc   LoadOK
0710 0988 C9 01 02              cmp   #MemFullError
0711 098B D0 23                 bne   LoadError
0712 098D 64 0D                 stz   TheSpecialFlag           ; don't try this again
0713 098F A6 0D                 ldx   TheSpecialFlag
0714 0991 20 D5 09     TooSmall jsr   DoInitialLoad
0715 0994 B0 1A                 bcs   LoadError
0716 0996 90 05                 bcc   LoadOK
0717 0998
0718 0998              ;---------------------------------------------------
0719 0998              ;
0720 0998              ; Restart was successful, make stack look same
0721 0998              ; as if called DoInitialLoad.
0722 0998              ;
0723 0998 68           SkipInitialLoad pla                     ; don't need user id
0724 0999 FA                    plx                            ; need starting addr
0725 099A 7A                    ply   
0726 099B 68                    pla                            ; don't need zp adr
0727 099C 68                    pla                            ; don't need zp size
0728 099D
0729 099D              LoadOK    
0730 099D
0731 099D
0732 099D              ;---------------------------------------------------
0733 099D              ;
0734 099D              ; Install the tool
0735 099D              ;
0736 099D F4 00 00              PushWord #0                    ; System Flag
0737 09A0 D4 11                 pei   TheToolNumber            ; Tool number
0738 09A2 5A                    phy                            ; Table Address
0739 09A3 DA                    phx   
0740 09A4 A2 01 0A 22           _SetTSPtr 
0741 09AB B0 03                 bcs   InstallError
0742 09AD
0743 09AD
0744 09AD 20 F5 09     DoNotLoad jsr   CheckVersion            ; any error will be in a-reg
0745 09B0
0746 09B0              ;---------------------------------------------------
0747 09B0              ;
0748 09B0              ; Copy the final value for SpecialFlag from to
0749 09B0              ; result word, and clean up the stack.
0750 09B0
0751 09B0              LoadError  
0752 09B0              InstallError  
0753 09B0
0754 09B0 A6 0D        FastExit ldx   TheSpecialFlag
0755 09B2 86 13                 stx   ResultSpecialFlag
0756 09B4
0757 09B4 48                    pha                            ; save the error code
0758 09B5 A5 01                 lda   PathHandle
0759 09B7 05 03                 ora   PathHandle+2
0760 09B9 F0 0B                 beq   NoHandle
0761 09BB D4 03                 pei   Pathhandle+2
0762 09BD D4 01                 pei   Pathhandle
0763 09BF A2 02 10 22           _DisposeHandle 
0764 09C6
0765 09C6 68           NoHandle pla                            ; get error code
0766 09C7
0767 09C7 FA                    plx                            ; strip off 4 words of local vars
0768 09C8 FA                    plx   
0769 09C9 FA                    plx   
0770 09CA FA                    plx   
0771 09CB 2B                    pld                            ; restore direct page
0772 09CC 7A                    ply                            ; get rts adr in y-reg for momment
0773 09CD FA                    plx                            ; pull 3 input words off stack
0774 09CE FA                    plx   
0775 09CF FA                    plx   
0776 09D0 5A                    phy                            ; put rts adr back on stack
0777 09D1
0778 09D1 C9 01 00              cmp   #1                       ; set carry based on error code
0779 09D4 60                    rts   
0780 09D5
0781 09D5
0782 09D5              ;---------------------------------------------------
0783 09D5              ;
0784 09D5              ; Local routine to handle making the intial load
0785 09D5              ; call.
0786 09D5              ;
0787 09D5              ; Inputs:
0788 09D5              ;    TheToolNumber
0789 09D5              ;    TheSpecialFlag
0790 09D5              ;
0791 09D5              ; Outputs:
0792 09D5              ;    x-reg   Low word of address of tool
0793 09D5              ;    y-reg   High word of address of tool
0794 09D5              ;    a-reg   Error code from InitialLoad call
0795 09D5              ;    carry   set if error, clear if none.
0796 09D5              ;
0797 09D5              ;
0798 09D5 A5 11        DoInitialLoad lda   TheToolNumber       ; get ID num back
0799 09D7 20 69 0B              jsr   MakeIDNum
0800 09DA DA                    phx                            ; space for zp segment size
0801 09DB DA                    phx                            ; space for zp segment starting address
0802 09DC DA                    phx                            ; space for starting address
0803 09DD DA                    phx   
0804 09DE DA                    phx                            ; space for userid
0805 09DF 48                    pha                            ; Push the Tools userID
0806 09E0 D4 07                 pei   PathPtr+2                ; Push pointer to the path name
0807 09E2 D4 05                 pei   PathPtr
0808 09E4 D4 0D                 pei   TheSpecialFlag           ; special memory flag
0809 09E6 A2 11 09 22           _InitialLoad 
0810 09ED 83 09                 sta   9,s                      ; save any error over zp size on stack
0811 09EF 68                    pla                            ; don't need user id
0812 09F0 FA                    plx                            ; need starting addr in x,y
0813 09F1 7A                    ply   
0814 09F2 68                    pla                            ; don't need zp adr
0815 09F3 68                    pla                            ; put error (if any back in a-reg)
0816 09F4
0817 09F4 60                    rts   
0818 09F5
0819 09F5
0820 09F5              ;---------------------------------------------------
0821 09F5              ;
0822 09F5              ; Check the version of the tool installed to
0823 09F5              ; be sure it is high enough.
0824 09F5              ;
0825 09F5              ; The Tool Set number and the Min required version are
0826 09F5              ; on direct page.
0827 09F5              ;
0828 09F5              ; I use the tool set number to make a version call.  If an error
0829 09F5              ; occurs, I return it.
0830 09F5              ;
0831 09F5              ; Using the version number that has returned, I mask off the
0832 09F5              ; high bit and start comparing.
0833 09F5              ;
0834 09F5              ; If the major part of the version number is greater than the
0835 09F5              ; minimum required version, the compare is complete.  If the
0836 09F5              ; major part of the version number is the same as the required
0837 09F5              ; version number then I go on to compare the minor part.
0838 09F5              ;
0839 09F5
0840 09F5              TempStorage equ 3 
0841 09F5              RealVersionNum equ 1 
0842 09F5
0843 09F5 48           CheckVersion pha                        ; space for temp storage.
0844 09F6 48                    pha                            ; space for version call result.
0845 09F7 A5 11                 lda   TheToolNumber            ; get tool number and make into
0846 09F9 09 00 04              ora   #$0400                   ; version call
0847 09FC AA                    tax   
0848 09FD 22 00 00 E1           jsl   $E10000                  ; (this will be RealVersion)
0849 0A01 B0 31                 bcs   FixStack
0850 0A03
0851 0A03 A3 01                 lda   RealVersionNum,s         ; clear the high bit that means
0852 0A05 29 FF 7F              and   #$7FFF                   ; prototype
0853 0A08 83 01                 sta   RealVersionNum,s
0854 0A0A 29 00 FF              and   #$FF00                   ; start with major version
0855 0A0D 83 03                 sta   TempStorage,s
0856 0A0F
0857 0A0F A5 0F                 lda   TheMinVersion            ; get desired version
0858 0A11 29 00 FF              and   #$FF00
0859 0A14 C3 03                 cmp   TempStorage,s
0860 0A16 90 19                 bcc   AllIsWell
0861 0A18 F0 05                 beq   CheckMinor
0862 0A1A
0863 0A1A A9 10 01     VersionError lda   #BadVersionNum
0864 0A1D 80 15                 bra   FixStack
0865 0A1F
0866 0A1F A3 01        CheckMinor lda   RealVersionNum,s       ; get the minor part
0867 0A21 29 FF 00              and   #$00FF
0868 0A24 83 03                 sta   TempStorage,s
0869 0A26 A5 0F                 lda   TheMinVersion
0870 0A28 29 FF 00              and   #$00FF
0871 0A2B C3 03                 cmp   TempStorage,s
0872 0A2D F0 02                 beq   AllIsWell
0873 0A2F B0 E9                 bcs   VersionError
0874 0A31
0875 0A31              ;---------------------------------------------------
0876 0A31              ;
0877 0A31              ; The version checked out okay.  Set error code
0878 0A31              ; to zero and fall into clean up code.
0879 0A31              ;
0880 0A31
0881 0A31              AllIsWell                               ; 
0882 0A31 A9 00 00              lda   #0                       ; No Error
0883 0A34
0884 0A34 FA           FixStack plx   
0885 0A35 FA                    plx   
0886 0A36
0887 0A36 C9 01 00              cmp   #1
0888 0A39 60                    rts   
0889 0A3A
0890 0A3A
0891 0A3A              ;---------------------------------------------------
0892 0A3A              ;
0893 0A3A              ; MakeToolPath
0894 0A3A              ;
0895 0A3A              ; 1.  Gets memory to hold a pathname.  Handle
0896 0A3A              ;     is put into PathHandle, and derefed into
0897 0A3A              ;     PathPtr.
0898 0A3A              ; 2.  Creates the path in PathHandle
0899 0A3A              ;
0900 0A3A              ;
0901 0A3A              MakeToolPath  
0902 0A3A
0903 0A3A              ;---------------------------------------------------
0904 0A3A              ;
0905 0A3A              ; First get memory and deref the handle.
0906 0A3A              ;
0907 0A3A A9 17 00              lda   #PathSize
0908 0A3D A2 00 80              ldx   #attrLocked
0909 0A40 20 AB 07              jsr   TLGetMem
0910 0A43 90 01                 bcc   GotIt
0911 0A45 60                    rts   
0912 0A46
0913 0A46 85 01        GotIt    sta   PathHandle
0914 0A48 86 03                 stx   PathHandle+2
0915 0A4A A7 01                 lda   [PathHandle]
0916 0A4C 85 05                 sta   PathPtr
0917 0A4E A0 02 00              ldy   #2
0918 0A51 B7 01                 lda   [PathHandle],y
0919 0A53 85 07                 sta   PathPtr+2
0920 0A55
0921 0A55
0922 0A55              ;---------------------------------------------------
0923 0A55              ;
0924 0A55              ; Now copy the first part of the path name into
0925 0A55              ; the memory we've obtained.
0926 0A55              ;
0927 0A55 8B                    phb                            ; set bank to this code bank
0928 0A56 4B                    phk   
0929 0A57 AB                    plb   
0930 0A58
0931 0A58 E2 30                 sep   #$30                     ; switch to 8 bit mode
0932 0A5A                       longa off
0933 0A5A                       longi off
0934 0A5A
0935 0A5A A0 16                 ldy   #PathSize-1              ; move the string
0936 0A5C B9 A1 0A     MoveLoop lda   |ToolPath,y
0937 0A5F 97 05                 sta   [PathPtr],y
0938 0A61 88                    dey   
0939 0A62 10 F8                 bpl   MoveLoop
0940 0A64
0941 0A64 C2 30                 rep   #$30                     ; back to full native
0942 0A66                       longa on
0943 0A66                       longi on
0944 0A66
0945 0A66 AB                    plb                            ; restore dbr.
0946 0A67
0947 0A67              ;---------------------------------------------------
0948 0A67              ;
0949 0A67              ; Finish up the path name by converting the tool
0950 0A67              ; number into ascii characters at the end of the
0951 0A67              ; path name.
0952 0A67
0953 0A67 D4 11                 pei   TheToolNumber            ; push the int
0954 0A69 A5 05                 lda   PathPtr
0955 0A6B 18                    clc   
0956 0A6C 69 14 00              adc   #o_OutChars
0957 0A6F AA                    tax   
0958 0A70 A5 07                 lda   PathPtr+2
0959 0A72 90 01                 bcc   NoCarry
0960 0A74 1A                    inc   a
0961 0A75 48           NoCarry  pha   
0962 0A76 DA                    phx   
0963 0A77 F4 03 00              PushWord #3                    ; 3 character output
0964 0A7A F4 00 00              PushWord #0                    ; unsigned
0965 0A7D A2 0B 26 22           _Int2Dec 
0966 0A84
0967 0A84              ;---------------------------------------------------
0968 0A84              ;
0969 0A84              ; Fix the path string so that any blanks left
0970 0A84              ; by _Int2Dec are converted to zeros.
0971 0A84              ;
0972 0A84 E2 30                 sep   #$30
0973 0A86                       longa off
0974 0A86                       longi off
0975 0A86 A0 14                 ldy   #o_OutChars
0976 0A88 B7 05                 lda   [PathPtr],y
0977 0A8A C9 20                 cmp   #' '
0978 0A8C D0 0F                 bne   NoMoreBlanks
0979 0A8E A9 30                 lda   #'0'
0980 0A90 97 05                 sta   [PathPtr],y
0981 0A92 C8                    iny   
0982 0A93 B7 05                 lda   [PathPtr],y
0983 0A95 C9 20                 cmp   #' '
0984 0A97 D0 04                 bne   NoMoreBlanks
0985 0A99 A9 30                 lda   #'0'
0986 0A9B 97 05                 sta   [PathPtr],y
0987 0A9D
0988 0A9D C2 30        NoMoreBlanks rep   #$30
0989 0A9F                       longa on
0990 0A9F                       longi on
0991 0A9F
0992 0A9F 18                    clc                            ; signal no error
0993 0AA0
0994 0AA0 60                    rts   
0995 0AA1
0996 0AA1
0997 0AA1 16           ToolPath DC B:PathLength
0998 0AA2 2A 2F 73 79  StartChars DC B:'*/system/tools/tool'
0999 0AB5              o_OutChars equ   *-ToolPath
1000 0AB5              PathLength equ   *-StartChars+3
1001 0AB5
1002 0AB5              PathSize equ   PathLength+1
1003 0AB5
1004 0AB5                       ENDP 
1005 0AB5
1006 0AB5
1007 0AB5
1008 0AB5                       title 'UnloadTools' 
1009 0AB5              ****************************************************************
1010 0AB5              *
1011 0AB5              UnloadTools PROC EXPORT 
1012 0AB5              *
1013 0AB5              * The Default TPT is restored.  Any tools that are active 
1014 0AB5              * but not part installed in the default TPT are made into
1015 0AB5              * zombies.
1016 0AB5              *
1017 0AB5              *
1018 0AB5              *
1019 0AB5              * Inputs:
1020 0AB5              *                   none
1021 0AB5              *
1022 0AB5              * Outputs:
1023 0AB5              *                   none
1024 0AB5              *
1025 0AB5              * External Refs:
1026 0AB5                       import MakeIDNum 
1027 0AB5                       import DummyTable 
1028 0AB5              *
1029 0AB5              * Entry Points:
1030 0AB5                       ENTRY UnloadThisTool 
1031 0AB5                       ENTRY SetupForUnload 
1032 0AB5                       ENTRY CleanupForUnload 
1033 0AB5              *
1034 0AB5                       longa on                       ; mode
1035 0AB5                       longi on
1036 0AB5              *
1037 0AB5              * Change History
1038 0AB5              *
1039 0AB5              * 05 Oct 87    Steven Glass
1040 0AB5              *
1041 0AB5              *    No changes were need to make this run in ROM.
1042 0AB5              *    However, many chnages were made to this routine because
1043 0AB5              *    we changed the UnloadTools algorithm.
1044 0AB5              *
1045 0AB5              *    In the original version of this routine, all tools not
1046 0AB5              *    in the original rom (1-13) except the loader (17) were
1047 0AB5              *    unloaded.  That is a user shutdown call was made on 
1048 0AB5              *    them to put them in zombie state and a dummy call table
1049 0AB5              *    was installed.
1050 0AB5              *
1051 0AB5              *    In this version we do a little more work.  The idea here
1052 0AB5              *    is to restore the "default" TPT.  
1053 0AB5              *
1054 0AB5              * 14 Oct 87    Steven Glass
1055 0AB5              *
1056 0AB5              * The loader (tool 17) is never unloaded.
1057 0AB5              *
1058 0AB5              *
1059 0AB5              * 15 Mar 89         Steven Glass
1060 0AB5              *
1061 0AB5              * _UserShutdown returns some undocumented errors that can
1062 0AB5              * really cause trouble so we just now ignore all errors.
1063 0AB5              *
1064 0AB5              * 07 Apr 89         Steven Glass
1065 0AB5              *
1066 0AB5              * Added range check to UnloadThisTool so that DummyTable would
1067 0AB5              * not be stored beyond the end of the real tpt if an unload call is
1068 0AB5              * made for a tool not in the defaultTPT.
1069 0AB5              *
1070 0AB5              ****************************************************************
1071 0AB5
1072 0AB5
1073 0AB5
1074 0AB5                       DefineStack 
1075 0AB5              OrigD    word 
1076 0AB5              RealTPT  long 
1077 0AB5              DefaultTPT long 
1078 0AB5              Counter  word 
1079 0AB5
1080 0AB5
1081 0AB5              ;---------------------------------------------------
1082 0AB5              ;
1083 0AB5              ; Set things up.
1084 0AB5              ;
1085 0AB5
1086 0AB5 20 30 0B              jsr   SetupforUnload           ; set up direct page
1087 0AB8
1088 0AB8
1089 0AB8 A9 01 00              lda   #1                       ; init the counter
1090 0ABB 85 0B                 sta   Counter
1091 0ABD
1092 0ABD              ;---------------------------------------------------
1093 0ABD              ;
1094 0ABD              ; Loop through each tool installed.
1095 0ABD              ;
1096 0ABD
1097 0ABD              Loop                                    ; 
1098 0ABD A5 0B                 lda   Counter                  ; Check to see if we are done.
1099 0ABF C7 03                 cmp   [RealTPT]
1100 0AC1 B0 07                 bcs   Done
1101 0AC3
1102 0AC3 20 D4 0A              jsr   UnloadThisTool           ; no so unload this one
1103 0AC6
1104 0AC6 E6 0B                 inc   counter                  ; bump the counter
1105 0AC8 80 F3                 bra   Loop
1106 0ACA
1107 0ACA              Done      
1108 0ACA
1109 0ACA              ;---------------------------------------------------
1110 0ACA              ;
1111 0ACA              ; Update the count in the real table from the
1112 0ACA              ; default table.  Note that the default TPT may
1113 0ACA              ; never be bigger than the real TPT.
1114 0ACA              ;
1115 0ACA A0 00 00              ldy   #0
1116 0ACD 20 5E 0B              jsr   MoveToReal
1117 0AD0
1118 0AD0
1119 0AD0              ;---------------------------------------------------
1120 0AD0              ;
1121 0AD0              ; Clean things up.
1122 0AD0              ;
1123 0AD0
1124 0AD0 20 55 0B              jsr   CleanupForUnload
1125 0AD3
1126 0AD3 60                    rts   
1127 0AD4
1128 0AD4
1129 0AD4              ;---------------------------------------------------
1130 0AD4              ;
1131 0AD4              ; UnloadThisTool
1132 0AD4              ;
1133 0AD4              ; Input
1134 0AD4              ;    Counter  ToolNumber
1135 0AD4              ;
1136 0AD4              ; This is the routine that does the work for each
1137 0AD4              ; tool to be unloaded.
1138 0AD4              ;
1139 0AD4              UnloadThisTool  
1140 0AD4
1141 0AD4 A5 0B                 lda   Counter
1142 0AD6
1143 0AD6 C9 11 00              cmp   #17                      ; is it the loader?
1144 0AD9 D0 01                 bne   continue                 ; No, so go on
1145 0ADB 60                    rts                            ; never unload the loader.
1146 0ADC
1147 0ADC C7 07        continue cmp   [DefaultTPT]             ; is it in the default table?
1148 0ADE 90 18                 bcc   InDefaultTable
1149 0AE0
1150 0AE0
1151 0AE0              ;
1152 0AE0              ; See if the tool is in the real table.  07 Apr 89  SEG
1153 0AE0              ;
1154 0AE0 D7 03                 cmp   [RealTPT],y              ; ROM 03 BUG - should not be indexed
1155 0AE2 90 01                 bcc   ItsIn
1156 0AE4
1157 0AE4 60                    rts   
1158 0AE5
1159 0AE5
1160 0AE5              ItsIn     
1161 0AE5              ;---------------------------------------------------
1162 0AE5              ;
1163 0AE5              ; This tool is not in the default table so 
1164 0AE5              ; install the dummy table into the real TPT
1165 0AE5              ;
1166 0AE5 A5 0B                 lda   Counter
1167 0AE7 0A                    asl   a
1168 0AE8 0A                    asl   a
1169 0AE9 A8                    tay   
1170 0AEA
1171 0AEA A9 65 02              lda   #DummyTable
1172 0AED 97 03                 sta   [RealTPT],y
1173 0AEF A9 FE 00              lda   #^DummyTable
1174 0AF2 C8                    iny   
1175 0AF3 C8                    iny   
1176 0AF4 97 03                 sta   [RealTPT],y
1177 0AF6 80 1C                 bra   ShutItDown
1178 0AF8
1179 0AF8
1180 0AF8              ;---------------------------------------------------
1181 0AF8              ;
1182 0AF8              ; This tool is in the default table.  If it is 
1183 0AF8              ; pointer is not the same in the real and the default
1184 0AF8              ; then copy from default to real and shut the tool
1185 0AF8              ; down.
1186 0AF8              ;
1187 0AF8 A5 0B        InDefaultTable lda   Counter
1188 0AFA 0A                    asl   a
1189 0AFB 0A                    asl   a
1190 0AFC A8                    tay   
1191 0AFD B7 07                 lda   [DefaultTPT],y
1192 0AFF D7 03                 cmp   [RealTPT],y
1193 0B01 D0 09                 bne   Adjust
1194 0B03 C8                    iny   
1195 0B04 C8                    iny   
1196 0B05 B7 07                 lda   [DefaultTPT],y
1197 0B07 D7 03                 cmp   [RealTPT],y
1198 0B09 D0 01                 bne   Adjust
1199 0B0B
1200 0B0B 60                    rts   
1201 0B0C
1202 0B0C A5 0B        Adjust   lda   Counter                  ; use counter to create table
1203 0B0E 0A                    asl   a                        ; offset used as input to 
1204 0B0F 0A                    asl   a                        ; movetoreal.
1205 0B10 A8                    tay   
1206 0B11 20 5E 0B              jsr   MoveToReal
1207 0B14
1208 0B14              ShutItDown                              ; 
1209 0B14              ; If the OS_Kind is not P16 then we skip this part.
1210 0B14 AF BC 00 E1           lda   >OS_Kind
1211 0B18 29 01 00              and   #$0001
1212 0B1B F0 12                 beq   SkipShutDown
1213 0B1D
1214 0B1D 48                    pha                            ; space for result
1215 0B1E A5 0B                 lda   Counter
1216 0B20 20 69 0B              jsr   MakeIDNum
1217 0B23 48                    pha                            ; ID to shut down
1218 0B24 F4 00 40              PushWord #$4000                ; leave me in memory as a ZOMBIE
1219 0B27 A2 11 12 22           _UserShutdown                  ; ignore errors
1220 0B2E
1221 0B2E FA                    plx                            ; clear stack from user shutdown call
1222 0B2F
1223 0B2F 60           SkipShutDown rts   
1224 0B30
1225 0B30
1226 0B30
1227 0B30
1228 0B30              ;---------------------------------------------------
1229 0B30              ;
1230 0B30              ; SetupForUnload
1231 0B30              ;
1232 0B30              ; Routine to setup stack and d-page for unloading 
1233 0B30              ; tools.  Must be ballenced by a CleanupForUnload
1234 0B30              ; call.
1235 0B30              ;
1236 0B30              ; Note that the a-reg is preserved by this routine.
1237 0B30              ;
1238 0B30
1239 0B30              SetupForUnload                          ; 
1240 0B30 FA                    plx                            ; get rts adr in x.
1241 0B31 A8                    tay                            ; preserve the a-reg
1242 0B32 48                    pha   
1243 0B33 48                    pha   
1244 0B34 48                    pha   
1245 0B35 48                    pha   
1246 0B36 48                    pha   
1247 0B37 0B                    phd   
1248 0B38
1249 0B38 3B                    tsc   
1250 0B39 5B                    tcd   
1251 0B3A
1252 0B3A AF C0 03 E1           lda   >TPTPtr
1253 0B3E 85 03                 sta   RealTPT
1254 0B40 AF C2 03 E1           lda   >TPTPtr+2
1255 0B44 85 05                 sta   RealTPT+2
1256 0B46
1257 0B46 AF 88 01 E1           lda   >DefaultTPTPtr
1258 0B4A 85 07                 sta   DefaultTPT
1259 0B4C AF 8A 01 E1           lda   >DefaultTPTPtr+2
1260 0B50 85 09                 sta   DefaultTPT+2
1261 0B52
1262 0B52 DA                    phx                            ; put rts adr back.
1263 0B53 98                    tya   
1264 0B54 60                    rts   
1265 0B55
1266 0B55
1267 0B55              ;---------------------------------------------------
1268 0B55              ;
1269 0B55              ; CleanupForUnload
1270 0B55              ;
1271 0B55              ; Cleans up the stack and d-page after unload calls.
1272 0B55              ; Must follow a SetupForUnload call.
1273 0B55              ; 
1274 0B55              ; Preserves the a-reg.
1275 0B55              ;
1276 0B55
1277 0B55 FA           CleanupForUnload plx   
1278 0B56 2B                    pld   
1279 0B57 7A                    ply   
1280 0B58 7A                    ply   
1281 0B59 7A                    ply   
1282 0B5A 7A                    ply   
1283 0B5B 7A                    ply   
1284 0B5C DA                    phx   
1285 0B5D 60                    rts   
1286 0B5E
1287 0B5E
1288 0B5E              ;---------------------------------------------------
1289 0B5E              ;
1290 0B5E              ; MoveToReal
1291 0B5E              ;
1292 0B5E              ; Copies 4 bytes from the DefaultTPT to the RealTPT
1293 0B5E              ; starting from the byte indicated by the y-reg.
1294 0B5E              ;
1295 0B5E B7 07        MoveToReal lda   [DefaultTPT],y
1296 0B60 97 03                 sta   [RealTPT],y
1297 0B62 C8                    iny   
1298 0B63 C8                    iny   
1299 0B64 B7 07                 lda   [DefaultTPT],y
1300 0B66 97 03                 sta   [RealTPT],y
1301 0B68 60                    rts   
1302 0B69
1303 0B69                       ENDP 
1304 0B69
1305 0B69
1306 0B69
1307 0B69              ****************************************************************
1308 0B69              *
1309 0B69              MakeIDNum PROC 
1310 0B69              *
1311 0B69              * Using the tool number in the a-register, return a
1312 0B69              * UserID for the Loader to use for the tool.
1313 0B69              *
1314 0B69              *
1315 0B69              * Inputs:
1316 0B69              *	a-reg : tool num
1317 0B69              *
1318 0B69              * Outputs:
1319 0B69              *	a-reg : UserID for tool.
1320 0B69              *
1321 0B69              * External Refs:
1322 0B69              *	none
1323 0B69              *
1324 0B69              * Entry Points:
1325 0B69              *	none
1326 0B69              *
1327 0B69                       longa on                       ; mode
1328 0B69                       longi on
1329 0B69              *
1330 0B69              * Change History
1331 0B69              *
1332 0B69              * 05 Oct 87    Steven Glass
1333 0B69              *
1334 0B69              *    No changes were needed to make this run in ROM.
1335 0B69              *
1336 0B69              ****************************************************************
1337 0B69
1338 0B69 29 FF 00              and   #$00FF                   ; mask off high word
1339 0B6C 09 00 40              ora   #$4000                   ; or in word for tools
1340 0B6F 60                    rts   
1341 0B70                       ENDP 
1342 0B70
1343 0B70
1344 0B70                       END   
